using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using OrderEntry.BusinessObjects;

namespace OrderEntry.Svc
{
    public class Service
    {
        public bool Start()
        {
            Console.WriteLine("Service started...");

            /*instantiate customers*/
            var customerList = BOCustomers.CustomersCollection();
            foreach (var customer in customerList)
                Task.Run(() => PlaceCustomerOrders(customer));

            return true;
        }

        private void PlaceCustomerOrders(BOCustomers customer)
        {
            Random r = new Random();

            int numOrders = r.Next(5, 20);
            decimal[] listPrice = { 30.0M, 90.0M, 2000.0M };
            decimal percentBidIncrease = ((decimal)r.Next(1, 10))/ 100;
            
            
            for (int k = 0; k < numOrders; k++)
            {
                var productList = BOProductList.ProductListCollection();
                foreach (var product in productList)
                {
                    int randomFactor = r.Next(25, 120);
                    /*bid a random price within a range of the expected price*/
                    decimal bidPrice = listPrice[(int)product.ProductId-1] * ((decimal)randomFactor / 100);
                    var newOrder = new BOPendingOrders()
                    {
                        CustomerId = customer.CustomerId,
                        ProductId = product.ProductId,
                        Quantity = 1,
                        BidPrice = bidPrice,
                        OrderDate = DateTime.Now,
                        OrderStatus = "NEW",
                        BidCount = 0
                    };
                    newOrder.SaveNew();
                    Console.WriteLine(customer.Name + " new order: " + product.Name + " at price: " + bidPrice);
                    /*simulate gap in orders*/
                    System.Threading.Thread.Sleep(randomFactor * 10);
                }
            }
            
            /*get list of customers pending orders and increase bid if necessary*/
            var countQry = new Criteria<BOPendingOrders>().Add(Expression.Eq("CustomerId", customer.CustomerId));
            var declinedQry = new Criteria<BOPendingOrders>()
                .Add(Expression.Eq("CustomerId", customer.CustomerId))
                .Add(Expression.Eq("OrderStatus", "DECLINED"));

            /*re-evalute count expression each time*/
            while (countQry.Count()> 0)
            {
                var declinedOrders = declinedQry.List<BOPendingOrders>();
                foreach(var order in declinedOrders)
                {
                    decimal oldBid = (decimal)order.BidPrice;
                    order.BidPrice = order.BidPrice * (1.0M + percentBidIncrease);
                    order.BidCount++;
                    order.OrderStatus = "NEW";
                    order.Update();
                    Console.WriteLine(customer.Name + " repriced OrderId (" + order.OrderId + ") from " + oldBid + " to " + order.BidPrice);
                }
                /*give it time to breathe*/
                System.Threading.Thread.Sleep(5000);
            }

            Console.WriteLine(customer.Name + " has no more orders outstanding and is exiting the market.");
        }

        public bool Stop()
        {
            return true;
        }

        public bool Pause()
        {
            Console.WriteLine("Service paused...");
            return true;
        }

        public bool Continue()
        {
            Console.WriteLine("Service continued...");
            return true;
        }
    }
}
